<?php
include "../config/koneksi.php";
session_start();

if (!isset($_SESSION['username']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'kasir')) {
    header("Location: ../login.php");
    exit();
}

if (isset($_GET['update'])) {
    $id = mysqli_real_escape_string($koneksi, $_GET['id']);
    $status = mysqli_real_escape_string($koneksi, $_GET['status']);
    
    mysqli_query($koneksi, 
        "UPDATE pesanan_online SET status = '$status' WHERE id_pesanan = '$id'");
    header("Location: kelola_pesanan.php");
    exit();
}

$pesanan = mysqli_query($koneksi, 
    "SELECT po.*, p.nama, pl.alamat, pl.no_hp 
     FROM pesanan_online po
     JOIN pelanggan pl ON po.id_pelanggan = pl.id_pelanggan
     JOIN users p ON pl.id_user = p.id_user
     ORDER BY po.tanggal DESC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Pesanan Online</title>
    <style>
        select { padding: 5px; }
        .status-btn { 
            padding: 5px 10px; 
            margin: 2px; 
            text-decoration: none;
            display: inline-block;
            font-size: 12px;
        }
        table { 
            width: 100%; 
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 10px; 
            text-align: left;
            vertical-align: top;
        }
        th { 
            background-color: #343a40; 
            color: white;
        }
        .aksi-links {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }
        .aksi-links a {
            padding: 3px 8px;
            border-radius: 3px;
            text-decoration: none;
            font-size: 13px;
        }
        .detail-btn {
            background: #17a2b8;
            color: white;
        }
        .struk-btn {
            background: #28a745;
            color: white;
        }
        .struk-btn:hover, .detail-btn:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body>
    <?php include "../assets/navbar.php"; ?>
    
    <div style="padding: 20px;">
        <h2>📋 Kelola Pesanan Online</h2>
        
        <table>
            <tr>
                <th width="5%">ID</th>
                <th width="25%">Pelanggan</th>
                <th width="15%">Tanggal</th>
                <th width="15%">Total</th>
                <th width="25%">Status</th>
                <th width="15%">Aksi</th>
            </tr>
            <?php while($p = mysqli_fetch_assoc($pesanan)) { ?>
            <tr>
                <td>#<?= str_pad($p['id_pesanan'], 6, '0', STR_PAD_LEFT); ?></td>
                <td>
                    <strong><?= $p['nama']; ?></strong><br>
                    <small>📱 <?= $p['no_hp']; ?></small><br>
                    <small>📍 <?= $p['alamat']; ?></small>
                </td>
                <td><?= date('d/m/Y H:i', strtotime($p['tanggal'])); ?></td>
                <td style="font-weight: bold; color: #28a745;">
                    Rp <?= number_format($p['total'], 0, ',', '.'); ?>
                </td>
                <td>
                    <div style="margin-bottom: 8px;">
                        <span style="
                            padding: 3px 10px;
                            border-radius: 15px;
                            font-size: 12px;
                            font-weight: bold;
                            background: 
                            <?php 
                                if ($p['status'] == 'menunggu') echo '#fff3cd';
                                elseif ($p['status'] == 'diproses') echo '#cce5ff';
                                elseif ($p['status'] == 'dikirim') echo '#d4edda';
                                else echo '#f8f9fa';
                            ?>;
                        ">
                            <?= strtoupper($p['status']); ?>
                        </span>
                    </div>
                    
                    <div style="display: flex; flex-wrap: wrap; gap: 3px;">
                        <a href="?update&id=<?= $p['id_pesanan']; ?>&status=menunggu" 
                           class="status-btn" 
                           style="background: #fff3cd; color: #856404;">
                            Menunggu
                        </a>
                        <a href="?update&id=<?= $p['id_pesanan']; ?>&status=diproses" 
                           class="status-btn" 
                           style="background: #cce5ff; color: #004085;">
                            Diproses
                        </a>
                        <a href="?update&id=<?= $p['id_pesanan']; ?>&status=dikirim" 
                           class="status-btn" 
                           style="background: #d4edda; color: #155724;">
                            Dikirim
                        </a>
                        <a href="?update&id=<?= $p['id_pesanan']; ?>&status=selesai" 
                           class="status-btn" 
                           style="background: #f8f9fa; color: #6c757d;">
                            Selesai
                        </a>
                    </div>
                </td>
                <td>
                    <div class="aksi-links">
                        <a href="detail_pesanan_admin.php?id=<?= $p['id_pesanan']; ?>" 
                           class="detail-btn">
                            👁️ Detail
                        </a>
                        <a href="../transaksi/cetak_struk.php?id=<?= $p['id_pesanan']; ?>&type=online" 
                           target="_blank" 
                           class="struk-btn">
                            🖨️ Cetak Struk
                        </a>
                    </div>
                </td>
            </tr>
            <?php } ?>
        </table>
        
        <?php 
        mysqli_data_seek($pesanan, 0);
        $total_pesanan = 0;
        $total_menunggu = 0;
        $total_diproses = 0;
        $total_dikirim = 0;
        $total_selesai = 0;
        
        while($p = mysqli_fetch_assoc($pesanan)) {
            $total_pesanan++;
            if ($p['status'] == 'menunggu') $total_menunggu++;
            if ($p['status'] == 'diproses') $total_diproses++;
            if ($p['status'] == 'dikirim') $total_dikirim++;
            if ($p['status'] == 'selesai') $total_selesai++;
        }
        ?>
        
        <div style="margin-top: 30px; background: #f8f9fa; padding: 15px; border-radius: 5px;">
            <h3>📊 Statistik Pesanan</h3>
            <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                <div style="padding: 10px; background: white; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <strong>Total Pesanan:</strong> <?= $total_pesanan; ?>
                </div>
                <div style="padding: 10px; background: #fff3cd; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <strong>Menunggu:</strong> <?= $total_menunggu; ?>
                </div>
                <div style="padding: 10px; background: #cce5ff; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <strong>Diproses:</strong> <?= $total_diproses; ?>
                </div>
                <div style="padding: 10px; background: #d4edda; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <strong>Dikirim:</strong> <?= $total_dikirim; ?>
                </div>
                <div style="padding: 10px; background: #f8f9fa; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <strong>Selesai:</strong> <?= $total_selesai; ?>
                </div>
            </div>
        </div>
    </div>
</body>
</html>