<?php
include "../config/koneksi.php";
session_start();

if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit();
}

$data = mysqli_query($koneksi, "SELECT * FROM barang");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Barang</title>
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        a { text-decoration: none; padding: 5px 10px; margin: 2px; }
        .btn-tambah { background: #4CAF50; color: white; }
        .btn-hapus { background: #f44336; color: white; }
        .btn-edit { background: #2196F3; color: white; }
    </style>
</head>
<body>
    <?php include "../assets/navbar.php"; ?>
    
    <div style="padding: 20px;">
        <h2>Data Barang</h2>
        <a href="tambah_barang.php" class="btn-tambah">+ Tambah Barang</a>
        
        <table>
            <tr></tr>
                <th>No</th>
                <th>Nama Barang</th>
                <th>Harga</th>
                <th>Stok</th>
                <th>Aksi</th>
            </tr>
            <?php 
            $no = 1;
            while($b = mysqli_fetch_assoc($data)) { 
            ?>
            <tr>
                <td><?= $no++; ?></td>
                <td><?= htmlspecialchars($b['nama_barang']); ?></td>
                <td>Rp <?= number_format($b['harga'], 0, ',', '.'); ?></td>
                <td><?= $b['stok']; ?></td>
                <td>
                    <a href="edit_barang.php?id=<?= $b['id_barang']; ?>" class="btn-edit">Edit</a>
                    <a href="hapus_barang.php?id=<?= $b['id_barang']; ?>" class="btn-hapus" 
                       onclick="return confirm('Yakin hapus barang ini?')">Hapus</a>
                </td>
            </tr>
            <?php } ?>
        </table>
    </div>
</body>
</html>