<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Dashboard - Warung Madura Sormin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f2f2f2;
            margin: 0;
        }

        .container {
            padding: 20px;
            max-width: 1200px;
            margin: auto;
        }

        .welcome {
            background: #4e73df;
            color: white;
            padding: 20px;
            border-radius: 6px;
            margin-bottom: 20px;
        }

        .welcome h2 {
            margin: 0 0 5px;
        }

        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px,1fr));
            gap: 15px;
            margin-bottom: 25px;
        }

        .card {
            background: white;
            padding: 15px;
            border-radius: 6px;
            box-shadow: 0 0 8px rgba(0,0,0,0.08);
            text-decoration: none;
            color: #333;
        }

        .card h4 {
            margin: 0;
            font-size: 14px;
            color: #666;
        }

        .card p {
            font-size: 22px;
            font-weight: bold;
            margin-top: 10px;
        }

        .menu {
            background: white;
            padding: 20px;
            border-radius: 6px;
            box-shadow: 0 0 8px rgba(0,0,0,0.08);
        }

        .menu h3 {
            margin-bottom: 15px;
        }

        .menu a {
            display: block;
            padding: 10px;
            border-bottom: 1px solid #eee;
            text-decoration: none;
            color: #333;
            font-size: 14px;
        }

        .menu a:hover {
            background: #f5f5f5;
        }

        footer {
            text-align: center;
            margin-top: 30px;
            font-size: 13px;
            color: #777;
        }
    </style>
</head>
<body>

<?php include "assets/navbar.php"; ?>

<div class="container">

    <div class="welcome">
        <h2>Selamat datang, <?= $_SESSION['nama']; ?></h2>
        <p>Role: <?= strtoupper($_SESSION['role']); ?></p>
        <small><?= date('d F Y, H:i'); ?></small>
    </div>

    <?php if (!empty($stats)): ?>
    <?php foreach ($stats as $stat): ?>
        <a href="<?= $stat['link']; ?>" class="card">
            <h4><?= $stat['title']; ?></h4>
            <p><?= $stat['value']; ?></p>
        </a>
    <?php endforeach; ?>
<?php endif; ?>


    <div class="menu">
        <h3>Menu</h3>

        <?php if ($_SESSION['role'] == 'admin'): ?>
            <a href="users/users.php">Kelola Users</a>
            <a href="barang/barang.php">Kelola Barang</a>
            <a href="admin/kelola_pesanan.php">Kelola Pesanan</a>
            <a href="transaksi/riwayat_transaksi.php">Riwayat Transaksi</a>

        <?php elseif ($_SESSION['role'] == 'kasir'): ?>
            <a href="transaksi/transaksi_kasir.php">Transaksi Baru</a>
            <a href="barang/barang.php">Kelola Barang</a>
            <a href="admin/kelola_pesanan.php">Kelola Pesanan</a>
            <a href="transaksi/riwayat_transaksi.php">Riwayat Transaksi</a>

        <?php elseif ($_SESSION['role'] == 'pelanggan'): ?>
            <a href="pelanggan/pesan_barang.php">Pesan Barang</a>
            <a href="pelanggan/riwayat_pesanan.php">Riwayat Pesanan</a>
            <a href="../transaksi/cetak_struk.php?id=1&type=online" target="_blank">Cetak Struk</a>
            <a href="#">Hubungi Admin</a>
        <?php endif; ?>
    </div>

    <footer>
        Warung Madura Sormin © <?= date('Y'); ?>
    </footer>

</div>

</body>
</html>
