<?php
include "../config/koneksi.php";
session_start();

if (!isset($_SESSION['username']) || $_SESSION['role'] != 'pelanggan') {
    header("Location: ../login.php");
    exit();
}

$id_pesanan = mysqli_real_escape_string($koneksi, $_GET['id']);

$detail = mysqli_query($koneksi, 
    "SELECT dp.*, b.nama_barang, b.harga 
     FROM detail_pesanan dp
     JOIN barang b ON dp.id_barang = b.id_barang
     WHERE dp.id_pesanan = '$id_pesanan'");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Pesanan</title>
</head>
<body>
    <?php include "../assets/navbar.php"; ?>
    
    <div style="padding: 20px;">
        <h2>Detail Pesanan #<?= $id_pesanan; ?></h2>
        <a href="riwayat_pesanan.php">← Kembali</a>
        
        <table style="margin-top: 20px; width: 100%;">
            <tr>
                <th>Nama Barang</th>
                <th>Harga</th>
                <th>Jumlah</th>
                <th>Subtotal</th>
            </tr>
            <?php 
            $total = 0;
            while($d = mysqli_fetch_assoc($detail)) { 
                $total += $d['subtotal'];
            ?>
            <tr>
                <td><?= $d['nama_barang']; ?></td>
                <td>Rp <?= number_format($d['harga'], 0, ',', '.'); ?></td>
                <td><?= $d['qty']; ?></td>
                <td>Rp <?= number_format($d['subtotal'], 0, ',', '.'); ?></td>
            </tr>
            <?php } ?>
            <tr style="font-weight: bold; background: #f8f9fa;">
                <td colspan="3" align="right">TOTAL:</td>
                <td>Rp <?= number_format($total, 0, ',', '.'); ?></td>
            </tr>
        </table>
    </div>
</body>
</html>