<?php
include "../config/koneksi.php";
session_start();

if (!isset($_SESSION['username']) || $_SESSION['role'] != 'pelanggan') {
    header("Location: ../login.php");
    exit();
}

$barang = mysqli_query($koneksi, "SELECT * FROM barang WHERE stok > 0");

$id_user = $_SESSION['id_user'];
$pelanggan = mysqli_fetch_assoc(mysqli_query($koneksi, 
    "SELECT p.* FROM pelanggan p 
     JOIN users u ON p.id_user = u.id_user 
     WHERE u.id_user = '$id_user'"));

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['barang'])) {
    $total = 0;
    $tanggal = date('Y-m-d H:i:s');
    
    $query_pesanan = "INSERT INTO pesanan_online (tanggal, id_pelanggan, total, status) 
                      VALUES ('$tanggal', '{$pelanggan['id_pelanggan']}', 0, 'menunggu')";
    mysqli_query($koneksi, $query_pesanan);
    $id_pesanan = mysqli_insert_id($koneksi);
   
    foreach ($_POST['barang'] as $id_barang => $qty) {
        if ($qty > 0) {
            $barang_data = mysqli_fetch_assoc(mysqli_query($koneksi, 
                "SELECT * FROM barang WHERE id_barang = '$id_barang'"));
            $subtotal = $barang_data['harga'] * $qty;
            
            mysqli_query($koneksi, 
                "INSERT INTO detail_pesanan (id_pesanan, id_barang, qty, subtotal) 
                 VALUES ('$id_pesanan', '$id_barang', '$qty', '$subtotal')");
            
            $total += $subtotal;
            
            // Kurangi stok
            mysqli_query($koneksi, 
                "UPDATE barang SET stok = stok - $qty WHERE id_barang = '$id_barang'");
        }
    }
    
    // Update total pesanan
    mysqli_query($koneksi, 
        "UPDATE pesanan_online SET total = '$total' WHERE id_pesanan = '$id_pesanan'");
    
    header("Location: riwayat_pesanan.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesan Barang Online</title>
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        .pesan-btn { background: #4CAF50; color: white; padding: 10px 20px; border: none; }
        .cart { position: fixed; right: 20px; top: 100px; background: white; padding: 20px; border: 1px solid #ddd; }
    </style>
</head>
<body>
    <?php include "../assets/navbar.php"; ?>
    
    <div style="padding: 20px;">
        <h2>Pesan Barang Online</h2>
        <p><strong>Data Diri:</strong> <?= $_SESSION['nama']; ?> | <?= $pelanggan['alamat']; ?> | <?= $pelanggan['no_hp']; ?></p>
        
        <form method="POST">
            <table>
                <tr>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok Tersedia</th>
                    <th>Jumlah Pesan</th>
                </tr>
                <?php while($b = mysqli_fetch_assoc($barang)) { ?>
                <tr>
                    <td><?= $b['nama_barang']; ?></td>
                    <td>Rp <?= number_format($b['harga'], 0, ',', '.'); ?></td>
                    <td><?= $b['stok']; ?></td>
                    <td>
                        <input type="number" name="barang[<?= $b['id_barang']; ?>]" 
                               min="0" max="<?= $b['stok']; ?>" value="0" style="width: 80px;">
                    </td>
                </tr>
                <?php } ?>
            </table>
            
            <button type="submit" class="pesan-btn" style="margin-top: 20px;">
                💳 Buat Pesanan
            </button>
        </form>
    </div>
</body>
</html>