<?php
include "../config/koneksi.php";
session_start();

if (!isset($_SESSION['username']) || $_SESSION['role'] != 'pelanggan') {
    header("Location: ../login.php");
    exit();
}

$id_user = $_SESSION['id_user'];
$pelanggan = mysqli_fetch_assoc(mysqli_query($koneksi, 
    "SELECT p.* FROM pelanggan p 
     JOIN users u ON p.id_user = u.id_user 
     WHERE u.id_user = '$id_user'"));

$pesanan = mysqli_query($koneksi, 
    "SELECT * FROM pesanan_online 
     WHERE id_pelanggan = '{$pelanggan['id_pelanggan']}' 
     ORDER BY tanggal DESC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Pesanan</title>
    <style>
        table { 
            border-collapse: collapse; 
            width: 100%; 
            margin-top: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 12px; 
            text-align: left; 
        }
        th { 
            background-color: #343a40; 
            color: white;
            font-weight: bold;
        }
        .menunggu { background: #fff3cd; }
        .diproses { background: #cce5ff; }
        .dikirim { background: #d4edda; }
        .selesai { background: #f8f9fa; }
        .status-badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            display: inline-block;
        }
        .btn-pesan {
            background: #4CAF50; 
            color: white; 
            padding: 10px 20px; 
            text-decoration: none;
            border-radius: 5px;
            display: inline-block;
            margin-bottom: 20px;
        }
        .btn-pesan:hover {
            background: #45a049;
        }
        .aksi-links {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }
        .aksi-links a {
            padding: 6px 12px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 14px;
            text-align: center;
            transition: all 0.3s;
        }
        .detail-link {
            background: #17a2b8;
            color: white;
        }
        .detail-link:hover {
            background: #138496;
        }
        .struk-link {
            background: #28a745;
            color: white;
        }
        .struk-link:hover {
            background: #218838;
        }
        .total-harga {
            font-weight: bold;
            color: #28a745;
        }
        .no-data {
            text-align: center;
            padding: 40px;
            color: #6c757d;
            font-style: italic;
        }
    </style>
</head>
<body>
    <?php include "../assets/navbar.php"; ?>
    
    <div style="padding: 20px; max-width: 1200px; margin: 0 auto;">
        <h2>📋 Riwayat Pesanan Online</h2>
        <a href="pesan_barang.php" class="btn-pesan">
            🛒 + Pesan Baru
        </a>
        
        <?php 
        if (mysqli_num_rows($pesanan) == 0): 
        ?>
            <div class="no-data">
                <h3>Belum ada pesanan</h3>
                <p>Silahkan buat pesanan pertama Anda!</p>
            </div>
        <?php else: ?>
        
        <table>
            <tr>
                <th width="5%">No</th>
                <th width="20%">Tanggal Pesanan</th>
                <th width="20%">No. Pesanan</th>
                <th width="15%">Total</th>
                <th width="20%">Status</th>
                <th width="20%">Aksi</th>
            </tr>
            <?php 
            $no = 1;
            while($p = mysqli_fetch_assoc($pesanan)) { 
                $warna = '';
                $status_class = '';
                if ($p['status'] == 'menunggu') {
                    $warna = 'menunggu';
                    $status_class = 'background: #fff3cd; color: #856404;';
                }
                if ($p['status'] == 'diproses') {
                    $warna = 'diproses';
                    $status_class = 'background: #cce5ff; color: #004085;';
                }
                if ($p['status'] == 'dikirim') {
                    $warna = 'dikirim';
                    $status_class = 'background: #d4edda; color: #155724;';
                }
                if ($p['status'] == 'selesai') {
                    $warna = 'selesai';
                    $status_class = 'background: #f8f9fa; color: #6c757d;';
                }
            ?>
            <tr class="<?= $warna; ?>">
                <td><?= $no++; ?></td>
                <td><?= date('d/m/Y H:i', strtotime($p['tanggal'])); ?></td>
                <td><strong>#<?= str_pad($p['id_pesanan'], 6, '0', STR_PAD_LEFT); ?></strong></td>
                <td class="total-harga">
                    Rp <?= number_format($p['total'], 0, ',', '.'); ?>
                </td>
                <td>
                    <span class="status-badge" style="<?= $status_class; ?>">
                        <?= strtoupper($p['status']); ?>
                    </span>
                    <?php if ($p['status'] == 'dikirim'): ?>
                        <br><small style="font-size: 11px; color: #666;">Sedang dalam pengiriman</small>
                    <?php elseif ($p['status'] == 'selesai'): ?>
                        <br><small style="font-size: 11px; color: #666;">Pesanan telah selesai</small>
                    <?php endif; ?>
                </td>
                <td>
                    <div class="aksi-links">
                        <a href="detail_pesanan.php?id=<?= $p['id_pesanan']; ?>" 
                           class="detail-link">
                            👁️ Lihat Detail
                        </a>
                        <a href="../transaksi/cetak_struk.php?id=<?= $p['id_pesanan']; ?>&type=online" 
                           target="_blank" 
                           class="struk-link">
                            🖨️ Cetak Struk
                        </a>
                    </div>
                </td>
            </tr>
            <?php } ?>
        </table>
        
        <?php
        mysqli_data_seek($pesanan, 0);
        $total_pesanan = mysqli_num_rows($pesanan);
        $total_menunggu = 0;
        $total_diproses = 0;
        $total_dikirim = 0;
        $total_selesai = 0;
        $total_nilai = 0;
        
        while($p = mysqli_fetch_assoc($pesanan)) {
            $total_nilai += $p['total'];
            if ($p['status'] == 'menunggu') $total_menunggu++;
            if ($p['status'] == 'diproses') $total_diproses++;
            if ($p['status'] == 'dikirim') $total_dikirim++;
            if ($p['status'] == 'selesai') $total_selesai++;
        }
        ?>
        
        <div style="margin-top: 30px; background: #f8f9fa; padding: 20px; border-radius: 8px;">
            <h3>📊 Ringkasan Pesanan Anda</h3>
            <div style="display: flex; gap: 15px; flex-wrap: wrap; margin-top: 15px;">
                <div style="flex: 1; min-width: 200px; background: white; padding: 15px; border-radius: 6px; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                    <div style="font-size: 24px; font-weight: bold; color: #343a40;"><?= $total_pesanan; ?></div>
                    <div style="color: #6c757d; font-size: 14px;">Total Pesanan</div>
                </div>
                <div style="flex: 1; min-width: 200px; background: white; padding: 15px; border-radius: 6px; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                    <div style="font-size: 24px; font-weight: bold; color: #28a745;">
                        Rp <?= number_format($total_nilai, 0, ',', '.'); ?>
                    </div>
                    <div style="color: #6c757d; font-size: 14px;">Total Pengeluaran</div>
                </div>
            </div>
            
            <div style="display: flex; gap: 15px; flex-wrap: wrap; margin-top: 15px;">
                <div style="flex: 1; min-width: 150px; background: #fff3cd; padding: 12px; border-radius: 6px;">
                    <strong>Menunggu:</strong> <?= $total_menunggu; ?>
                </div>
                <div style="flex: 1; min-width: 150px; background: #cce5ff; padding: 12px; border-radius: 6px;">
                    <strong>Diproses:</strong> <?= $total_diproses; ?>
                </div>
                <div style="flex: 1; min-width: 150px; background: #d4edda; padding: 12px; border-radius: 6px;">
                    <strong>Dikirim:</strong> <?= $total_dikirim; ?>
                </div>
                <div style="flex: 1; min-width: 150px; background: #f8f9fa; padding: 12px; border-radius: 6px;">
                    <strong>Selesai:</strong> <?= $total_selesai; ?>
                </div>
            </div>
        </div>
        
        <?php endif; ?>
    </div>
</body>
</html>