<?php
include "../config/koneksi.php";
session_start();

if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit();
}

$id = mysqli_real_escape_string($koneksi, $_GET['id']);

if (isset($_GET['type']) && $_GET['type'] == 'online') {
    $transaksi = mysqli_fetch_assoc(mysqli_query($koneksi, 
        "SELECT po.*, u.nama as nama_pelanggan, pl.alamat, pl.no_hp 
         FROM pesanan_online po
         JOIN pelanggan pl ON po.id_pelanggan = pl.id_pelanggan
         JOIN users u ON pl.id_user = u.id_user
         WHERE po.id_pesanan = '$id'"));
    
    $detail = mysqli_query($koneksi, 
        "SELECT dp.*, b.nama_barang, b.harga 
         FROM detail_pesanan dp
         JOIN barang b ON dp.id_barang = b.id_barang
         WHERE dp.id_pesanan = '$id'");
    
    $jenis = "ONLINE";
} else {
    $transaksi = mysqli_fetch_assoc(mysqli_query($koneksi, 
        "SELECT t.*, u.nama as nama_kasir 
         FROM transaksi t
         JOIN users u ON t.id_user = u.id_user
         WHERE t.id_transaksi = '$id'"));
    
    $detail = mysqli_query($koneksi, 
        "SELECT dt.*, b.nama_barang, b.harga 
         FROM detail_transaksi dt
         JOIN barang b ON dt.id_barang = b.id_barang
         WHERE dt.id_transaksi = '$id'");
    
    $jenis = "OFFLINE";
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Struk - <?= $jenis; ?></title>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 0; }
            .struk-container { width: 80mm !important; margin: 0 auto !important; box-shadow: none !important; }
        }
        
        body { font-family: 'Courier New', monospace; }
        .struk-container { 
            width: 300px; 
            margin: 20px auto; 
            padding: 15px; 
            border: 1px solid #000; 
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .header { text-align: center; border-bottom: 1px dashed #000; padding-bottom: 10px; margin-bottom: 10px; }
        .item { display: flex; justify-content: space-between; margin: 5px 0; }
        .total { border-top: 2px solid #000; margin-top: 10px; padding-top: 10px; font-weight: bold; }
        .footer { text-align: center; margin-top: 15px; font-size: 12px; border-top: 1px dashed #000; padding-top: 10px; }
        .btn-cetak { 
            background: #007bff; 
            color: white; 
            padding: 10px 20px; 
            border: none; 
            cursor: pointer; 
            margin: 10px; 
        }
    </style>
</head>
<body>
    <div class="no-print" style="text-align: center; padding: 20px;">
        <button onclick="window.print()" class="btn-cetak">🖨️ Cetak Struk</button>
        <button onclick="window.history.back()" class="btn-cetak">⬅️ Kembali</button>
    </div>
    
    <div class="struk-container">
        <div class="header">
            <h2 style="margin: 0; font-size: 18px;">WARUNG MADURA SORMIN</h2>
            <p style="margin: 5px 0; font-size: 12px;">Jl. Raya Madura No. 123</p>
            <p style="margin: 5px 0; font-size: 12px;">Telp: 0812-3456-7890</p>
            <p style="margin: 5px 0; font-size: 12px;"><?= date('d/m/Y H:i:s'); ?></p>
            <p style="margin: 5px 0; font-size: 12px; background: #f0f0f0; padding: 3px;">
                <strong>TRANSAKSI <?= $jenis; ?></strong>
            </p>
        </div>
        
        <?php if ($jenis == "ONLINE"): ?>
            <div class="item">
                <span>No. Pesanan:</span>
                <span>#<?= str_pad($transaksi['id_pesanan'], 6, '0', STR_PAD_LEFT); ?></span>
            </div>
            <div class="item">
                <span>Pelanggan:</span>
                <span><?= $transaksi['nama_pelanggan']; ?></span>
            </div>
            <div class="item">
                <span>Alamat:</span>
                <span><?= $transaksi['alamat']; ?></span>
            </div>
            <div class="item">
                <span>No. HP:</span>
                <span><?= $transaksi['no_hp']; ?></span>
            </div>
            <div class="item">
                <span>Status:</span>
                <span><strong><?= strtoupper($transaksi['status']); ?></strong></span>
            </div>
        <?php else: ?>
            <div class="item">
                <span>No. Transaksi:</span>
                <span>#<?= str_pad($transaksi['id_transaksi'], 6, '0', STR_PAD_LEFT); ?></span>
            </div>
            <div class="item">
                <span>Kasir:</span>
                <span><?= $transaksi['nama_kasir']; ?></span>
            </div>
        <?php endif; ?>
        
        <hr style="border-top: 1px dashed #000; margin: 10px 0;">
        
        <div style="margin: 10px 0;">
            <div class="item" style="font-weight: bold;">
                <span>ITEM</span>
                <span>QTY x HARGA = SUBTOTAL</span>
            </div>
            
            <?php 
            $grand_total = 0;
            while($d = mysqli_fetch_assoc($detail)) { 
                $grand_total += $d['subtotal'];
            ?>
            <div class="item">
                <span><?= $d['nama_barang']; ?></span>
                <span><?= $d['qty']; ?> x <?= number_format($d['harga'], 0, ',', '.'); ?> = <?= number_format($d['subtotal'], 0, ',', '.'); ?></span>
            </div>
            <?php } ?>
        </div>
        
        <hr style="border-top: 1px dashed #000; margin: 10px 0;">
        
        <div class="total">
            <div class="item">
                <span>TOTAL:</span>
                <span>Rp <?= number_format($grand_total, 0, ',', '.'); ?></span>
            </div>
            <?php if ($jenis == "OFFLINE"): ?>
            <div class="item">
                <span>BAYAR:</span>
                <span>Rp <?= number_format($grand_total, 0, ',', '.'); ?></span>
            </div>
            <div class="item">
                <span>KEMBALI:</span>
                <span>Rp 0</span>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="footer">
            <p style="margin: 5px 0;">*** TERIMA KASIH SUDAH BELANJA ***</p>
            <p style="margin: 5px 0; font-size: 10px;">Barang yang sudah dibeli<br>tidak dapat ditukar/dikembalikan</p>
        </div>
    </div>
    
    <script>
      
        window.onload = function() {
            if (window.location.search.includes('autoprint')) {
                window.print();
            }
        };
    </script>
</body>
</html>