<?php
include "../config/koneksi.php";
session_start();

// Hanya admin/kasir yang bisa akses
if (!isset($_SESSION['username']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'kasir')) {
    header("Location: ../login.php");
    exit();
}

// Ambil riwayat transaksi
$transaksi = mysqli_query($koneksi, 
    "SELECT t.*, u.nama as nama_kasir 
     FROM transaksi t
     JOIN users u ON t.id_user = u.id_user
     ORDER BY t.tanggal DESC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Transaksi Offline</title>
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        .btn-cetak { background: #28a745; color: white; padding: 5px 10px; text-decoration: none; }
        .btn-transaksi { background: #007bff; color: white; padding: 10px 15px; text-decoration: none; }
    </style>
</head>
<body>
    <?php include "../assets/navbar.php"; ?>
    
    <div style="padding: 20px;">
        <h2>Riwayat Transaksi Offline</h2>
        <a href="transaksi_kasir.php" class="btn-transaksi">+ Transaksi Baru</a>
        
        <table style="margin-top: 20px;">
            <tr>
                <th>No</th>
                <th>ID Transaksi</th>
                <th>Tanggal</th>
                <th>Kasir</th>
                <th>Total</th>
                <th>Aksi</th>
            </tr>
            <?php 
            $no = 1;
            while($t = mysqli_fetch_assoc($transaksi)) { 
            ?>
            <tr>
                <td><?= $no++; ?></td>
                <td>#<?= str_pad($t['id_transaksi'], 6, '0', STR_PAD_LEFT); ?></td>
                <td><?= date('d/m/Y H:i', strtotime($t['tanggal'])); ?></td>
                <td><?= $t['nama_kasir']; ?></td>
                <td>Rp <?= number_format($t['total'], 0, ',', '.'); ?></td>
                <td>
                    <a href="cetak_struk.php?id=<?= $t['id_transaksi']; ?>" class="btn-cetak" target="_blank">
                        🖨️ Cetak Ulang
                    </a>
                </td>
            </tr>
            <?php } ?>
        </table>
    </div>
</body>
</html>