<?php
include "../config/koneksi.php";
session_start();

if (!isset($_SESSION['username']) || ($_SESSION['role'] != 'kasir' && $_SESSION['role'] != 'admin')) {
    header("Location: ../login.php");
    exit();
}

$barang = mysqli_query($koneksi, "SELECT * FROM barang WHERE stok > 0 ORDER BY nama_barang");

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['barang'])) {
    $total = 0;
    $tanggal = date('Y-m-d H:i:s');
    $id_user = $_SESSION['id_user'];
    
    $query_transaksi = "INSERT INTO transaksi (tanggal, id_user, total) 
                        VALUES ('$tanggal', '$id_user', 0)";
    mysqli_query($koneksi, $query_transaksi);
    $id_transaksi = mysqli_insert_id($koneksi);
 
    foreach ($_POST['barang'] as $id_barang => $qty) {
        if ($qty > 0) {
            $barang_data = mysqli_fetch_assoc(mysqli_query($koneksi, 
                "SELECT * FROM barang WHERE id_barang = '$id_barang'"));
            $subtotal = $barang_data['harga'] * $qty;
            
            mysqli_query($koneksi, 
                "INSERT INTO detail_transaksi (id_transaksi, id_barang, qty, subtotal) 
                 VALUES ('$id_transaksi', '$id_barang', '$qty', '$subtotal')");
            
            $total += $subtotal;
            
            mysqli_query($koneksi, 
                "UPDATE barang SET stok = stok - $qty WHERE id_barang = '$id_barang'");
        }
    }
    
    mysqli_query($koneksi, 
        "UPDATE transaksi SET total = '$total' WHERE id_transaksi = '$id_transaksi'");
    
    header("Location: cetak_struk.php?id=$id_transaksi");
    exit();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaksi Kasir</title>
    <style>
        table { border-collapse: collapse; width: 100%; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        .total-box { background: #f8f9fa; padding: 15px; margin: 20px 0; border: 2px dashed #333; }
        .btn-proses { background: #28a745; color: white; padding: 15px 30px; font-size: 16px; border: none; cursor: pointer; }
        .btn-proses:hover { background: #218838; }
        .qty-input { width: 60px; padding: 5px; text-align: center; }
    </style>
</head>
<body>
    <?php include "../assets/navbar.php"; ?>
    
    <div style="padding: 20px;">
        <h2>💳 Transaksi Kasir (Offline)</h2>
        <p>Kasir: <strong><?= $_SESSION['nama']; ?></strong> | Tanggal: <?= date('d/m/Y H:i:s'); ?></p>
        
        <form method="POST" id="formTransaksi">
            <table>
                <tr style="background: #343a40; color: white;">
                    <th width="5%">No</th>
                    <th width="40%">Nama Barang</th>
                    <th width="15%">Harga</th>
                    <th width="15%">Stok</th>
                    <th width="15%">Jumlah</th>
                    <th width="20%">Subtotal</th>
                </tr>
                <?php 
                $no = 1;
                while($b = mysqli_fetch_assoc($barang)) { 
                ?>
                <tr>
                    <td><?= $no++; ?></td>
                    <td><?= htmlspecialchars($b['nama_barang']); ?></td>
                    <td>Rp <?= number_format($b['harga'], 0, ',', '.'); ?></td>
                    <td><?= $b['stok']; ?></td>
                    <td>
                        <input type="number" class="qty-input" name="barang[<?= $b['id_barang']; ?>]" 
                               min="0" max="<?= $b['stok']; ?>" value="0" 
                               onchange="hitungSubtotal(this, <?= $b['harga']; ?>)">
                    </td>
                    <td id="subtotal_<?= $b['id_barang']; ?>">Rp 0</td>
                </tr>
                <?php } ?>
            </table>
            
            <div class="total-box">
                <h3>Total Belanja: <span id="totalAll">Rp 0</span></h3>
            </div>
            
            <button type="submit" class="btn-proses">
                🖨️ Proses Transaksi & Cetak Struk
            </button>
        </form>
    </div>
    
    <script>
        function hitungSubtotal(input, harga) {
            let qty = parseInt(input.value) || 0;
            let subtotal = qty * harga;
            
            document.getElementById('subtotal_' + input.name.match(/\[(\d+)\]/)[1]).innerText = 
                'Rp ' + subtotal.toLocaleString('id-ID');
            
            hitungTotal();
        }
        
        function hitungTotal() {
            let total = 0;
            let inputs = document.querySelectorAll('.qty-input');
            
            inputs.forEach(input => {
                let qty = parseInt(input.value) || 0;
                let harga = parseInt(input.getAttribute('onchange').match(/hitungSubtotal\(this, (\d+)\)/)[1]);
                total += qty * harga;
            });
            
            document.getElementById('totalAll').innerText = 'Rp ' + total.toLocaleString('id-ID');
        }
     
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.qty-input').forEach(input => {
                input.addEventListener('input', function() {
                    let harga = parseInt(this.getAttribute('onchange').match(/hitungSubtarget\(this, (\d+)\)/)[1]);
                    hitungSubtotal(this, harga);
                });
            });
        });
    </script>
</body>
</html>