<?php
include "../config/koneksi.php";
session_start();

if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit();
}

if ($_SESSION['role'] != 'admin') {
    header("Location: ../dashboard.php");
    exit();
}

$data = mysqli_query($koneksi, "SELECT * FROM users");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Users</title>
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        a { text-decoration: none; padding: 5px 10px; margin: 2px; }
        .btn-tambah { background: #4CAF50; color: white; }
        .btn-hapus { background: #f44336; color: white; }
        .btn-edit { background: #2196F3; color: white; }
    </style>
</head>
<body>
   <?php "/asset/navbar.php"; ?>
    
    <div style="padding: 20px;">
        <h2>Data Users</h2>
        <a href="tambah_users.php" class="btn-tambah">+ Tambah User</a>
        
        <table>
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>Username</th>
                <th>Role</th>
                <th>Aksi</th>
            </tr>
            <?php 
            $no = 1;
            while($u = mysqli_fetch_assoc($data)) { 
            ?>
            <tr>
                <td><?= $no++; ?></td>
                <td><?= htmlspecialchars($u['nama']); ?></td>
                <td><?= htmlspecialchars($u['username']); ?></td>
                <td><?= htmlspecialchars($u['role']); ?></td>
                <td>
                    <a href="hapus_user.php?id=<?= $u['id_user']; ?>" class="btn-hapus" 
                       onclick="return confirm('Yakin hapus user ini?')">Hapus</a>
                </td>
            </tr>
            <?php } ?>
        </table>
    </div>
</body>
</html>